<?php
require_once '../includes/config.php';

class FilesController {
    private $client;

    public function __construct($openAIClient) {
        $this->client = $openAIClient;
    }

    public function handleRequest() {
        try {
            header('Content-Type: application/json');
            
            $action = $_GET['action'] ?? 'list';
            
            $result = match($action) {
                'list' => $this->listFiles(),
                'retrieve' => $this->retrieveFile(),
                'delete' => $this->deleteFile(),
                default => throw new \Exception('Action not found')
            };

            return json_encode($result);
        } catch (\Exception $e) {
            error_log('Controller Error: ' . $e->getMessage());
            http_response_code(500);
            return json_encode(['error' => $e->getMessage()]);
        }
    }

    private function listFiles() {
        try {
            error_log("=== Starting listFiles ===");
            $response = $this->client->files()->list();
            error_log("Files response: " . print_r($response, true));
            
            return [
                'success' => true,
                'data' => $response->data
            ];
        } catch (\Exception $e) {
            error_log('Error listing files: ' . $e->getMessage());
            error_log('Stack trace: ' . $e->getTraceAsString());
            throw $e;
        }
    }

    private function retrieveFile() {
        try {
            $fileId = $_GET['id'] ?? null;
            if (!$fileId) {
                throw new \Exception('File ID is required');
            }

            $response = $this->client->files()->retrieve($fileId);
            return [
                'success' => true,
                'data' => $response
            ];
        } catch (\Exception $e) {
            error_log('Error retrieving file: ' . $e->getMessage());
            throw $e;
        }
    }

    private function deleteFile() {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            $fileId = $data['file_id'] ?? null;
            
            if (!$fileId) {
                throw new \Exception('File ID is required');
            }

            $response = $this->client->files()->delete($fileId);
            return [
                'success' => true,
                'data' => $response
            ];
        } catch (\Exception $e) {
            error_log('Error deleting file: ' . $e->getMessage());
            throw $e;
        }
    }
}

try {
    $controller = new FilesController($openAIClient);
    echo $controller->handleRequest();
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
} 