let currentPage = 1;

function loadThreads(page = 1) {
    // Show loading state
    const tbody = document.getElementById('threads-tbody');
    tbody.innerHTML = '<tr><td colspan="3" class="text-center">Loading...</td></tr>';

    fetch(`controllers/ThreadsController.php?action=list&page=${page}`)
        .then(response => response.json())
        .then(data => {
            tbody.innerHTML = '';
            data.data.forEach(thread => {
                tbody.innerHTML += `
                    <tr>
                        <td>${thread.id}</td>
                        <td>${new Date(thread.created_at * 1000).toLocaleString()}</td>
                        <td>
                            <button onclick="deleteThread('${thread.id}')" class="btn-icon">
                                <i class="material-icons">delete</i>
                            </button>
                        </td>
                    </tr>
                `;
            });
            updatePagination(data.has_more, page);
        });
} 