// Shared functions
function showNotification(message, type = 'success') {
    const notification = document.createElement('div');
    notification.className = `notification ${type}`;
    notification.textContent = message;
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.remove();
    }, 3000);
}

function closeModal() {
    try {
        const modals = document.querySelectorAll('.modal');
        modals.forEach(modal => {
            if (modal) {
                modal.style.display = 'none';
                modal.classList.remove('active');
                
                // Reset any forms inside the modal
                const form = modal.querySelector('form');
                if (form) {
                    form.reset();
                }
            }
        });
    } catch (error) {
        console.error('Error closing modal:', error);
    }
}

function updatePagination(hasMore, currentPage, loadFunction) {
    const pagination = document.querySelector('.pagination');
    if (!pagination) return;
    
    let html = '';
    if (currentPage > 1) {
        html += `<button onclick="${loadFunction}(${currentPage - 1})">Previous</button>`;
    }
    html += `<button class="active">${currentPage}</button>`;
    if (hasMore) {
        html += `<button onclick="${loadFunction}(${currentPage + 1})">Next</button>`;
    }
    pagination.innerHTML = html;
}

function showLoader(button) {
    // Save original content
    button.dataset.originalContent = button.innerHTML;
    
    if (button.classList.contains('btn-icon')) {
        // For icon buttons
        button.innerHTML = '<div class="loader"></div>';
    } else if (button.classList.contains('btn-primary')) {
        // For primary buttons
        button.innerHTML = `
            <div class="button-loader">
                <div class="loader"></div>
                <span>Processing...</span>
            </div>
        `;
    } else {
        // For secondary buttons
        button.innerHTML = `
            <div class="button-loader">
                <div class="loader secondary"></div>
                <span>Processing...</span>
            </div>
        `;
    }
    button.disabled = true;
}

function hideLoader(button) {
    if (button.dataset.originalContent) {
        button.innerHTML = button.dataset.originalContent;
        delete button.dataset.originalContent;
    }
    button.disabled = false;
}

function showModal(modalId) {
    try {
        const modal = document.getElementById(modalId);
        if (modal) {
            modal.style.display = 'flex';
            modal.classList.add('active');
        }
    } catch (error) {
        console.error('Error showing modal:', error);
    }
} 