<?php
require_once '../includes/config.php';

class AuthController {
    public function handleRequest() {
        $action = $_GET['action'] ?? 'login';
        
        switch($action) {
            case 'login':
                return $this->handleLogin();
            case 'logout':
                return $this->handleLogout();
            default:
                http_response_code(404);
                return json_encode(['error' => 'Action not found']);
        }
    }

    private function handleLogin() {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            $username = $data['username'] ?? '';
            $password = $data['password'] ?? '';

            if ($username === AUTH_USERNAME && $password === AUTH_PASSWORD) {
                session_start();
                $_SESSION[AUTH_SESSION_KEY] = true;
                $_SESSION['last_activity'] = time();
                
                return json_encode([
                    'success' => true,
                    'message' => 'Login successful'
                ]);
            }

            http_response_code(401);
            return json_encode([
                'success' => false,
                'error' => 'Invalid credentials'
            ]);
        } catch (\Exception $e) {
            error_log('Login error: ' . $e->getMessage());
            http_response_code(500);
            return json_encode(['error' => 'Login failed']);
        }
    }

    private function handleLogout() {
        session_start();
        session_destroy();
        return json_encode([
            'success' => true,
            'message' => 'Logged out successfully'
        ]);
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $controller = new AuthController();
    echo $controller->handleRequest();
} 