<?php
require_once 'includes/config.php';

// Define base path constant
define('BASEPATH', true);

// Start session
session_start();

// Check if user is logged in
if (!isset($_SESSION[AUTH_SESSION_KEY])) {
    header('Location: views/auth/login.php');
    exit;
}

// Check session timeout (30 minutes)
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > 1800)) {
    session_destroy();
    header('Location: views/auth/login.php');
    exit;
}
$_SESSION['last_activity'] = time();

// Get the current page from URL parameter, default to assistants
$page = $_GET['page'] ?? 'assistants';

// Initialize page scripts array
$pageScripts = [];

// Set page-specific scripts
switch($page) {
    case 'assistants':
        $pageScripts[] = 'assets/js/assistants.js';
        break;
    case 'vectorstores':
        $pageScripts[] = 'assets/js/vectorstores.js';
        $pageScripts[] = 'assets/js/vectorstore-files.js';
        break;
    case 'assign':
        $pageScripts[] = 'assets/js/assign.js';
        break;
    case 'files':
        $pageScripts[] = 'assets/js/files.js';
        break;
    case 'chat':
        $pageScripts[] = 'assets/js/chat.js';
        break;
}

// Start the layout
include 'views/layout/header.php';
include 'views/layout/sidebar.php';
?>

<div class="main-content">
    <?php
    // Load the appropriate page content
    switch($page) {
        case 'assistants':
            include 'views/assistants/index.php';
            break;
        case 'threads':
            include 'views/threads/index.php';
            break;
        case 'vectorstores':
            include 'views/vectorstores/index.php';
            break;
        case 'assign':
            include 'views/assign/index.php';
            break;
        case 'files':
            include 'views/files/index.php';
            break;
        case 'chat':
            $pageTitle = 'Chat Assistant';
            include 'views/chat/index.php';
            break;
        default:
            include 'views/assistants/index.php';
    }
    ?>
</div>

<?php include 'views/layout/footer.php'; ?> 