<?php
error_log("Loading assistants view");
?>
<div class="card">
    <div class="card-header">
        <h2>Assistants</h2>
        <button class="btn" onclick="createAssistant()">Create New Assistant</button>
    </div>
    
    <div class="assistants-list">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Name / ID</th>
                    <th>Model</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody id="assistants-tbody">
                <!-- Data will be loaded here via AJAX -->
            </tbody>
        </table>
    </div>
    
    <div class="pagination" id="assistants-pagination">
        <!-- Pagination will be loaded here via AJAX -->
    </div>
</div>

<!-- Assistant Form Modal -->
<div class="modal" id="assistantModal">
    <div class="modal-content">
        <div class="modal-header">
            <h3 id="modalTitle">Create Assistant</h3>
            <button type="button" class="close-btn" onclick="closeModal()">×</button>
        </div>
        <form id="assistantForm" onsubmit="saveAssistant(event)">
            <!-- Form content will be loaded dynamically -->
        </form>
    </div>
</div> 