<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - OpenAI Dashboard</title>
    <link href="https://fonts.googleapis.com/css2?family=Google+Sans:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="/assistant/assets/css/styles.css" rel="stylesheet">
    <style>
        /* Updated notification styles */
        .notification {
            position: fixed;
            top: 24px;
            right: 24px;
            padding: 16px 24px;
            border-radius: 4px;
            font-size: 14px;
            color: white;
            background: #d93025;
            z-index: 9999;
            animation: slideInTop 0.3s ease-out;
            max-width: 400px;
            min-height: 52px;
            display: flex;
            align-items: center;
            box-shadow: 0 2px 4px rgba(0,0,0,0.2);
        }

        @keyframes slideInTop {
            from {
                transform: translateY(-100%);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        /* Add fade out animation */
        .notification.fade-out {
            animation: fadeOut 0.3s ease-out forwards;
        }

        @keyframes fadeOut {
            from {
                opacity: 1;
                transform: translateY(0);
            }
            to {
                opacity: 0;
                transform: translateY(-100%);
            }
        }
    </style>
</head>
<body class="login-page">
    <div class="login-container">
        <div class="login-box">
            <h1>OpenAI Dashboard</h1>
            <p class="login-subtitle">Sign in to continue</p>
            <form id="loginForm" onsubmit="handleLogin(event)">
                <div class="form-group">
                    <input type="text" id="username" name="username" required placeholder="Username">
                </div>
                <div class="form-group">
                    <input type="password" id="password" name="password" required placeholder="Password">
                </div>
                <button type="submit" class="btn btn-primary login-btn">Sign in</button>
            </form>
        </div>
    </div>

    <script>
        // Add showNotification function directly in login page
        function showNotification(message, type = 'error') {
            // Remove any existing notifications
            const existingNotifications = document.querySelectorAll('.notification');
            existingNotifications.forEach(notification => {
                notification.remove();
            });

            const notification = document.createElement('div');
            notification.className = `notification ${type}`;
            notification.textContent = message;
            document.body.appendChild(notification);
            
            // Add fade out animation before removing
            setTimeout(() => {
                notification.classList.add('fade-out');
                setTimeout(() => {
                    notification.remove();
                }, 300); // Match the animation duration
            }, 2700); // Start fade out before the full 3 seconds
        }

        function handleLogin(event) {
            event.preventDefault();
            
            const form = event.target;
            const button = form.querySelector('button');
            button.disabled = true;
            button.innerHTML = 'Signing in...';
            
            fetch('/assistant/api/AuthController.php?action=login', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    username: form.username.value,
                    password: form.password.value
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    window.location.href = '/assistant/index.php';
                } else {
                    showNotification(data.error || 'Invalid credentials');
                    button.disabled = false;
                    button.innerHTML = 'Sign in';
                }
            })
            .catch(error => {
                showNotification('Login failed');
                button.disabled = false;
                button.innerHTML = 'Sign in';
            });
        }
    </script>
</body>
</html> 