<?php
// Ensure this view is not loaded directly
defined('BASEPATH') or exit('No direct script access allowed');
?>

<div class="chat-container">
    <div class="chat-sidebar">
        <div class="chat-header">
            <button class="btn btn-primary new-chat-btn" onclick="createNewThread()">
                <i class="material-icons">add</i>
                New Chat
            </button>
        </div>
        <div class="threads-section">
            <div class="threads-title">Chat History</div>
            <div class="threads-list" id="threadsList"></div>
        </div>
        <div class="vector-store-section">
            <div class="vector-store-title">Knowledge Base</div>
            <select id="vectorStoreSelect" class="form-control">
                <option value="">Select Vector Store</option>
            </select>
        </div>
    </div>
    <div class="chat-main">
        <div class="chat-top-bar">
            <div class="chat-title">
                <input type="text" id="threadName" placeholder="Chat Name" onchange="updateThreadName()">
            </div>
            <div class="chat-actions">
                <div class="stream-toggle">
                    <label class="toggle-label">
                        <input type="checkbox" id="streamToggle">
                        <span>Stream Response</span>
                    </label>
                </div>
                <button class="btn btn-icon delete" onclick="deleteThread()" title="Delete Chat">
                    <i class="material-icons">delete</i>
                </button>
            </div>
        </div>
        <div class="chat-messages" id="chatMessages"></div>
        <div class="chat-input-area">
            <div class="chat-input-wrapper">
                <textarea 
                    id="messageInput" 
                    placeholder="Type your message..." 
                    rows="1"
                    onkeydown="handleKeyPress(event)"
                ></textarea>
                <button class="btn btn-icon send-btn" onclick="sendMessage()">
                    <i class="material-icons">send</i>
                </button>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/marked/marked.min.js"></script>
<script src="assets/js/chat.js"></script>
<script src="assets/js/utils.js"></script>
<script src="assets/js/chat.js"></script> 