<div class="card">
    <div class="card-header">
        <h2>OpenAI Files</h2>
        <div class="header-subtitle">Manage your OpenAI files</div>
        <button onclick="deleteAllFiles()" class="btn btn-danger">
            <i class="material-icons">delete_sweep</i>
            Delete All Files
        </button>
    </div>
    <div class="file-manager-content">
        <!-- Files List -->
        <div class="content-header">
            <div class="header-cell" style="width: 65%">Name</div>
            <div class="header-cell" style="width: 20%">Size</div>
            <div class="header-cell" style="width: 15%">Status</div>
        </div>
        
        <div id="loadingState" class="file-manager-message">
            <div class="spinner"></div>
            <div class="message">Loading files...</div>
        </div>
        
        <div id="emptyState" class="file-manager-message" style="display: none;">
            <i class="material-icons">folder_open</i>
            <div class="message">No files found</div>
        </div>
        
        <div id="errorState" class="file-manager-message" style="display: none;">
            <i class="material-icons">error_outline</i>
            <div class="message error">Error loading files</div>
        </div>
        
        <div id="filesList" class="files-list" style="display: none;"></div>
    </div>
</div>

<!-- File Details Modal -->
<div class="modal" id="fileDetailsModal">
    <div class="modal-content modal-sm">
        <div class="modal-header">
            <h3>File Details</h3>
            <button type="button" class="close-btn" onclick="closeFileDetailsModal()">×</button>
        </div>
        <div class="modal-body">
            <div id="fileDetails">
                <div class="file-manager-message">
                    <div class="spinner"></div>
                    <div class="message">Loading file details...</div>
                </div>
            </div>
        </div>
    </div>
</div>