<div class="sidebar">
    <div class="logo">
        <h1 style="padding: 20px; color: var(--primary-color); font-size: 20px;">OpenAI Dashboard</h1>
    </div>
    <nav>
        <ul>
            <li><a href="index.php?page=assistants" class="<?php echo $page === 'assistants' ? 'active' : ''; ?>">
                <i class="material-icons">smart_toy</i> Assistants
            </a></li>
            <li><a href="index.php?page=threads" class="<?php echo $page === 'threads' ? 'active' : ''; ?>">
                <i class="material-icons">forum</i> Threads
            </a></li>
            <li><a href="index.php?page=vectorstores" class="<?php echo $page === 'vectorstores' ? 'active' : ''; ?>">
                <i class="material-icons">storage</i> Vector Stores
            </a></li>
            <li>
                <a href="?page=assign" <?php echo $page === 'assign' ? 'class="active"' : ''; ?>>
                    <i class="material-icons">link</i>
                    Assign Vector Stores
                </a>
            </li>
            <li>
                <a href="?page=files" <?php echo ($page === 'files') ? 'class="active"' : ''; ?>>
                    <i class="material-icons">folder</i>
                    File Manager
                </a>
            </li>
            <li>
                <a href="?page=chat" <?php echo ($page === 'chat') ? 'class="active"' : ''; ?>>
                    <i class="material-icons">chat</i>
                    Chat Assistant
                </a>
            </li>
            <li class="sidebar-divider"></li>
            <li>
                <a href="#" onclick="handleLogout(event)" class="logout-link">
                    <i class="material-icons">logout</i> Logout
                </a>
            </li>
        </ul>
    </nav>
</div>

<script>
function handleLogout(event) {
    event.preventDefault();
    if (confirm('Are you sure you want to logout?')) {
        fetch('/assistant/api/AuthController.php?action=logout', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            }
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Logout failed');
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                window.location.href = '/assistant/views/auth/login.php';
            } else {
                throw new Error(data.error || 'Logout failed');
            }
        })
        .catch(error => {
            console.error('Logout error:', error);
            alert('Failed to logout. Please try again.');
        });
    }
}
</script> 