<?php
// Add debug output
error_log("Loading vector stores view");
?>
<div class="card">
    <div class="card-header">
        <h2>Vector Stores</h2>
        <button class="btn" id="createVectorStoreBtn">Create New Vector Store</button>
    </div>
    
    <div class="vectorstores-list">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Name / ID</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody id="vectorstores-tbody">
                <!-- Data will be loaded here via AJAX -->
            </tbody>
        </table>
    </div>
    
    <div class="pagination" id="vectorstores-pagination">
        <!-- Pagination will be loaded here via AJAX -->
    </div>
</div>

<!-- Vector Store Form Modal -->
<div class="modal" id="vectorStoreModal">
    <div class="modal-content">
        <div class="modal-header">
            <h3 id="modalTitle">Create Vector Store</h3>
            <button type="button" class="close-btn" onclick="closeVectorStoreModal()">×</button>
        </div>
        <form id="vectorStoreForm" onsubmit="saveVectorStore(event)">
            <input type="hidden" id="vectorstore_id" name="vectorstore_id">
            
            <div class="form-group">
                <label for="name">Name</label>
                <input type="text" id="name" name="name" required>
            </div>

            <div class="form-actions">
                <button type="button" class="btn btn-secondary" data-action="close-modal">Cancel</button>
                <button type="submit" class="btn btn-primary">Save</button>
            </div>
        </form>
    </div>
</div> 

<?php include 'views/vectorstores/files.php'; ?> 